/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.SymbolTableSource;
import emulator.hardware.HwWord;
import java.io.PrintStream;

public class SymbolTableEntry {
    public static final int SYMBOL_TYPE_UNKNOWN = 0;
    public static final int SYMBOL_TYPE_CODE = 1;
    public static final int SYMBOL_TYPE_DATA = 2;
    public static final int SYMBOL_TYPE_WORD = 3;
    public static final int SYMBOL_TYPE_TEXT = 4;
    public static final int SYMBOL_TYPE_CHIP = 5;
    public static final int SYMBOL_TYPE_EMPTY = 6;
    private int address = 0;
    private String label = null;
    private String remark = null;
    private int type = 0;
    private SymbolTableSource symbolSource = null;

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSource(SymbolTableSource symbolSource) {
        this.symbolSource = symbolSource;
    }

    public SymbolTableSource getSource() {
        return this.symbolSource;
    }

    public static SymbolTableEntry createFromString(String string) {
        String[] words;
        String line;
        SymbolTableEntry entry = null;
        if (string != null && !(line = string.trim()).isEmpty() && line.charAt(0) != ';' && (words = line.split("[\\s\t]+")).length > 0) {
            entry = words[0].equals("al") ? SymbolTableEntry.parseLabelLine(words) : SymbolTableEntry.parseSymbolLine(words);
        }
        return entry;
    }

    private static SymbolTableEntry parseLabelLine(String[] words) {
        SymbolTableEntry entry = null;
        if (words.length >= 3) {
            int address = Integer.parseInt(words[1], 16);
            String label = words[2];
            if (!label.endsWith("__")) {
                if (label.charAt(0) == '.') {
                    label = label.substring(1);
                }
                entry = new SymbolTableEntry();
                entry.setAddress(address);
                entry.setLabel(label);
            }
        }
        return entry;
    }

    private static SymbolTableEntry parseSymbolLine(String[] words) {
        int address;
        SymbolTableEntry entry = null;
        if (words.length >= 2 && (address = Integer.parseInt(words[0], 16)) >= 0 && address <= 65535) {
            int last_word;
            entry = new SymbolTableEntry();
            entry.setAddress(address);
            if (words[1].length() > 1) {
                entry.setLabel(words[1]);
            }
            if ((last_word = words.length - 1) > 1) {
                int type = SymbolTableEntry.getTypeFromString(words[last_word]);
                if (type != 0) {
                    entry.setType(type);
                    --last_word;
                } else {
                    entry.setType(1);
                }
                if (last_word > 1) {
                    String remark = words[2];
                    int i = 3;
                    while (i <= last_word) {
                        remark = String.valueOf(remark) + " " + words[i];
                        ++i;
                    }
                    if (!remark.isEmpty()) {
                        entry.setRemark(remark);
                    }
                }
            } else {
                entry.setType(1);
            }
        }
        return entry;
    }

    private static int getTypeFromString(String type_string) {
        int type = 0;
        if (type_string.equals("CODE")) {
            type = 1;
        } else if (type_string.equals("DATA")) {
            type = 2;
        } else if (type_string.equals("WORD")) {
            type = 3;
        } else if (type_string.equals("TEXT")) {
            type = 4;
        } else if (type_string.equals("CHIP")) {
            type = 5;
        } else if (type_string.equals("EMPTY")) {
            type = 6;
        }
        return type;
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 5: {
                return "CHIP";
            }
            case 1: {
                return "CODE";
            }
            case 2: {
                return "DATA";
            }
            case 6: {
                return "EMPTY";
            }
            case 4: {
                return "TEXT";
            }
            case 3: {
                return "WORD";
            }
        }
        return "";
    }

    public void dump(PrintStream out) {
        out.print(String.valueOf(this.label) + " " + this.address + " \"" + this.remark + "\"");
    }

    private static String spaces(int count) {
        String s = new String();
        int i = 0;
        while (i < count) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }

    public void writeLine(PrintStream ostream) {
        String labelField;
        int LABEL_LENGTH = 16;
        int REMARK_LENGTH = 60;
        String string = this.label != null ? (this.label.length() < LABEL_LENGTH ? String.valueOf(this.label) + SymbolTableEntry.spaces(LABEL_LENGTH).substring(this.label.length()) : this.label) : (labelField = "-" + SymbolTableEntry.spaces(LABEL_LENGTH - 1));
        String remarkField = this.remark != null ? (this.remark.length() < REMARK_LENGTH ? String.valueOf(this.remark) + SymbolTableEntry.spaces(REMARK_LENGTH).substring(this.remark.length()) : this.remark) : SymbolTableEntry.spaces(REMARK_LENGTH);
        ostream.println(new HwWord((long)this.address) + "    " + labelField + "  " + remarkField + "  " + SymbolTableEntry.getTypeString(this.type));
    }
}

